using System;
using System.Data;
using System.Data.SqlClient;
using System.Reflection;
using gov.va.med.vbecs.ExceptionManagement;
using STOREDPROC = gov.va.med.vbecs.Common.VbecsStoredProcs;
using BLOODPRODUCT = gov.va.med.vbecs.Common.VbecsTables.BloodProduct;
using HCPCSASSIGNMENT = gov.va.med.vbecs.Common.VbecsTables.HcpcsAssignment;

namespace gov.va.med.vbecs.DAL 
{
	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Cameron Taylor</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>8/28/2002</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>
	/// Static class implementing a data persistence logic for BOL.BloodProduct class.
	/// Retrieves from/saves to database BOL.BloodProduct class data. 
	///</summary>
	public class BloodProduct 
	{
		
		#region Static Methods

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/28/2002</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="323"> 
		///		<ExpectedInput>Product code</ExpectedInput>
		///		<ExpectedOutput>The DataTable containing blood products</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="1183"> 
		///		<ExpectedInput>Invalid Product Code</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Overloaded static method to return a DataTable of blood products 
		/// matching the given product code and division code.
		/// </summary>
		/// <param name="productCode">Blood product code</param>
		/// <returns>
		/// DataTable containing list of blood products with specified 
		/// product code available in given division.
		/// NOTE: there may be products with the same product code!
		/// </returns>
		public static DataTable GetBloodProductByCode(string productCode)
		{			
			SqlParameter[] prms =
			{
				new SqlParameter(STOREDPROC.GetBloodProductByCode.productcode, System.Data.SqlDbType.VarChar),
				new SqlParameter(STOREDPROC.GetBloodProductByCode.divisioncode, System.Data.SqlDbType.Char)
			};
			
			prms[0].Value = productCode;
			prms[1].Value = Common.LogonUser.LogonUserDivisionCode;
			
			DataSet ds = Common.StoredProcedure.GetData(STOREDPROC.GetBloodProductByCode.StoredProcName, prms);

			return ds.Tables[0];
		}

		///<Developers>
		///	<Developer>D. Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>4/10/2007</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8481"> 
		///		<ExpectedInput>Valid ProductCode</ExpectedInput>
		///		<ExpectedOutput>DataTable</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="8482"> 
		///		<ExpectedInput>Invalid or Inactive ProductCode</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Overloaded static method to return a DataTable of blood products 
		/// matching the given product code and division code.
		/// This version searches for both active and local roducts (CR 2210)	
		/// </summary>
		/// <returns>
		/// DataTable containing list of blood products with specified 
		/// product code available in given division.
		/// NOTE: there may be products with the same product code!
		/// </returns>
		public static DataTable GetActiveOrLocalBloodProductsByCode(string productCode)
		{			
			SqlParameter[] prms =
			{
				new SqlParameter(STOREDPROC.GetActiveOrLocalBloodProductsByCode.productcode, System.Data.SqlDbType.VarChar),
				new SqlParameter(STOREDPROC.GetActiveOrLocalBloodProductsByCode.divisioncode, System.Data.SqlDbType.Char)
			};
			//
			prms[0].Value = productCode;
			prms[1].Value = Common.LogonUser.LogonUserDivisionCode;
			//
			DataSet ds = Common.StoredProcedure.GetData(STOREDPROC.GetActiveOrLocalBloodProductsByCode.StoredProcName, prms);
			//
			return ds.Tables[0];
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/11/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="820"> 
		///		<ExpectedInput>Active BloodProductGuid</ExpectedInput>
		///		<ExpectedOutput>True</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="821"> 
		///		<ExpectedInput>Inactive BloodProductGuid</ExpectedInput>
		///		<ExpectedOutput>False</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// IsBloodProductOnActiveUnits
		/// Adding LocalSupplierGuid (of shipper) - per SME, is how this call should function
		/// </summary>
		/// <param name="bloodProductGuid"></param>
		/// <param name="localSupplierGuid"></param>
		/// <returns></returns>
		public static bool IsBloodProductOnActiveUnits(System.Guid bloodProductGuid, System.Guid localSupplierGuid)
		{
			SqlParameter[] prms =
			{
				new SqlParameter(STOREDPROC.IsBloodProductOnActiveUnits.bloodproductguid, System.Data.SqlDbType.UniqueIdentifier),
				new SqlParameter(STOREDPROC.IsBloodProductOnActiveUnits.divisioncode, System.Data.SqlDbType.Char),
				new SqlParameter(STOREDPROC.IsBloodProductOnActiveUnits.localsupplierguid, System.Data.SqlDbType.UniqueIdentifier)
			};
			//
			prms[0].Value = bloodProductGuid;
			prms[1].Value = Common.LogonUser.LogonUserDivisionCode;
			prms[2].Value = localSupplierGuid;
			//
			return new Common.StoredProcedure().GetBoolReturnValue( STOREDPROC.IsBloodProductOnActiveUnits.StoredProcName, prms );
		}


		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/11/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="822"> 
		///		<ExpectedInput>BloodProductGuid</ExpectedInput>
		///		<ExpectedOutput>DataTable with Hcpcs History</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="823"> 
		///		<ExpectedInput>Invalid ProductGuid</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// GetHcpcsAssignmentHistory
		/// </summary>
		/// <param name="bloodProductGuid"></param>
		/// <returns></returns>
		public static DataTable GetHcpcsAssignmentHistory(System.Guid bloodProductGuid)
		{			
			SqlParameter[] prms =
			{
				new SqlParameter(STOREDPROC.GetHcpcsAssignmentHistory.bloodproductguid, System.Data.SqlDbType.UniqueIdentifier),
				new SqlParameter(STOREDPROC.GetHcpcsAssignmentHistory.divisioncode, System.Data.SqlDbType.Char)
			};

			prms[0].Value = bloodProductGuid;
			prms[1].Value = Common.LogonUser.LogonUserDivisionCode;
			
			DataSet ds = Common.StoredProcedure.GetData(STOREDPROC.GetHcpcsAssignmentHistory.StoredProcName, prms);

			return ds.Tables[0];
		}


		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/11/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="824"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable Schema</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="827"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// GetEmptyBloodProductTable
		/// </summary>
		/// <returns></returns>
		public static System.Data.DataTable GetEmptyBloodProductTable()
		{
			DataTable _dt = new System.Data.DataTable(BLOODPRODUCT.TableName);

			_dt.Columns.Add(BLOODPRODUCT.BloodProductGuid, typeof(System.Guid));
			_dt.Columns.Add(BLOODPRODUCT.CrossmatchRequiredIndicator, typeof(bool));
			_dt.Columns.Add(BLOODPRODUCT.LastUpdateUser, typeof(bool));
			_dt.Columns.Add(BLOODPRODUCT.MaximumStorageTime, typeof(decimal));
			_dt.Columns.Add(BLOODPRODUCT.ProductAttributeForm , typeof(string));
			_dt.Columns.Add(BLOODPRODUCT.ProductCode, typeof(string));
			_dt.Columns.Add(BLOODPRODUCT.ProductCodeIndicator , typeof(bool));
			_dt.Columns.Add(BLOODPRODUCT.ProductModificationIndicator , typeof(bool));
			_dt.Columns.Add(BLOODPRODUCT.ProductName, typeof(string));
			_dt.Columns.Add(BLOODPRODUCT.ProductShortName , typeof(string));
			_dt.Columns.Add(BLOODPRODUCT.ProductTypeCode , typeof(string));
			_dt.Columns.Add(BLOODPRODUCT.ProductVolume , typeof(string));
			_dt.Columns.Add(BLOODPRODUCT.RecordStatusCode , typeof(char));

			return _dt;
		}



		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/8/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7459"> 
		///		<ExpectedInput>true</ExpectedInput>
		///		<ExpectedOutput>DataTable with RowVersion</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="7460"> 
		///		<ExpectedInput>false</ExpectedInput>
		///		<ExpectedOutput>DataTable without RowVersion</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// spInsertHcpcsAssignment, spUpdateHcpcsAssignment
		/// </summary>
		/// <param name="isUpdate"></param>
		/// <returns></returns>
		public static System.Data.DataTable GetEmptyHcpcsAssignmentTableSchema(bool isUpdate)
		{
			DataTable dtHpcpcs = new System.Data.DataTable(HCPCSASSIGNMENT.TableName);

			dtHpcpcs.Columns.Add(HCPCSASSIGNMENT.HcpcsAssignmentGuid, typeof(System.Guid));
			dtHpcpcs.Columns.Add(HCPCSASSIGNMENT.DivisionCode, typeof(string));
			dtHpcpcs.Columns.Add(HCPCSASSIGNMENT.LastUpdateFunctionId, typeof(int));

			if (isUpdate)
			{
				dtHpcpcs.Columns.Add(HCPCSASSIGNMENT.RowVersion , typeof(byte[]));
			}
			else
			{
				dtHpcpcs.Columns.Add(HCPCSASSIGNMENT.BloodProductGuid, typeof(System.Guid));
				dtHpcpcs.Columns.Add(HCPCSASSIGNMENT.HcpcsCode , typeof(string));
			}

			return dtHpcpcs;
		}


		///<Developers>
		///	<Developer>Luke Meyer</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/14/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1098"> 
		///		<ExpectedInput>Active productcode</ExpectedInput>
		///		<ExpectedOutput>True</ExpectedOutput>
		///	</Case>
		///	<Case type="1" testid ="1099"> 
		///		<ExpectedInput>Inactive productcode</ExpectedInput>
		///		<ExpectedOutput>False</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Checks if a specified blood product is active.
		/// </summary>
		/// <param name="bloodproductguid">Blood product Guid</param>
		/// <returns>Boolean value indicating if blood product if active or not</returns>
		public static bool IsBloodProductActive(System.Guid bloodproductguid)
		{
			SqlParameter[] prms =
			{
				new SqlParameter(STOREDPROC.IsBloodProductActive.bloodproductguid, System.Data.SqlDbType.UniqueIdentifier),
				new SqlParameter(STOREDPROC.IsBloodProductActive.divisioncode, System.Data.SqlDbType.Char)
			};
			//
			prms[0].Value = bloodproductguid;
			prms[1].Value = Common.LogonUser.LogonUserDivisionCode;
			
			bool retValue = new Common.StoredProcedure().GetBoolReturnValue( STOREDPROC.IsBloodProductActive.StoredProcName, prms );

			return(retValue);
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/11/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2057"> 
		///		<ExpectedInput>BloodProductGuid, SupplierGuid</ExpectedInput>
		///		<ExpectedOutput>True</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="2060"> 
		///		<ExpectedInput>BloodProuctGuid, bad SupplierGuid</ExpectedInput>
		///		<ExpectedOutput>False</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Checks the RecordStatusCode on the ProductShipper table for a row containing the LocalSupplierGuid
		/// </summary>
		/// <param name="bloodProductGuid"></param>
		/// <param name="localSupplierGuid"></param>
		/// <returns></returns>
		public static bool IsProductShipperActive(System.Guid bloodProductGuid, System.Guid localSupplierGuid)
		{	
			SqlParameter[] prms =
			{
				new SqlParameter(STOREDPROC.IsProductShipperActive.bloodproductguid, System.Data.SqlDbType.UniqueIdentifier),
				new SqlParameter(STOREDPROC.IsProductShipperActive.localsupplierguid, System.Data.SqlDbType.UniqueIdentifier)
			};
			
			prms[0].Value = bloodProductGuid;
			prms[1].Value = localSupplierGuid;
		
			return new Common.StoredProcedure().GetBoolReturnValue( STOREDPROC.IsProductShipperActive.StoredProcName, prms );
		}


		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/11/2002</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="496"> 
		///		<ExpectedInput>Valid BloodProductGuid</ExpectedInput>
		///		<ExpectedOutput>The DataTable containing the blood product</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="1884"> 
		///		<ExpectedInput>Invalid BloodProductGuid</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets a DataTable with blood product data based on a blood product 
		/// GUID and a division code. Although blood product GUID unambiguously
		/// identifies a blood product, division code is required in order to get 
		/// a blood product only if it's available for specified division.
		/// </summary>
		/// <param name="bloodProductGuid">Blood product GUID</param>
		/// <returns>Single blood product data contained within a DataTable</returns>
		public static DataTable GetBloodProductByGuid(System.Guid bloodProductGuid)
		{
			SqlParameter[] prms =	
			{
				new SqlParameter(STOREDPROC.GetBloodProductByGuid.bloodproductguid, System.Data.SqlDbType.UniqueIdentifier),
				new SqlParameter(STOREDPROC.GetBloodProductByGuid.divisioncode, System.Data.SqlDbType.Char)
			};

			prms[0].Value = bloodProductGuid;
			prms[1].Value = Common.LogonUser.LogonUserDivisionCode;
						
			DataSet ds = Common.StoredProcedure.GetData(STOREDPROC.GetBloodProductByGuid.StoredProcName, prms);
			
			return ds.Tables[0];
		}


		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/28/2002</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="322"> 
		///		<ExpectedInput>Product name, product type code</ExpectedInput>
		///		<ExpectedOutput>The DataTable containing the blood product</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="1885"> 
		///		<ExpectedInput>Invalid ProductName, Invalid ProductTypeCode</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Searches for blood products matching entered product type code, division 
		/// code and/or product name (may be partial or unspecified) criteria.
		/// </summary>
		/// <param name="productName">Product name - partial value or blank accepted</param>
		/// <param name="productTypeCode">Product type code</param>
		/// <returns>DataTable containing list of products matching the search parameters</returns>
		public static DataTable BloodProductSearch( string productName, string productTypeCode)
		{
			SqlParameter[] prms =
			{
				new SqlParameter(STOREDPROC.BloodProductSearch.productname, System.Data.SqlDbType.VarChar),
				new SqlParameter(STOREDPROC.BloodProductSearch.producttypecode, System.Data.SqlDbType.Char),
				new SqlParameter(STOREDPROC.BloodProductSearch.divisioncode, System.Data.SqlDbType.Char)
			};

			prms[0].Value = productName;
			prms[1].Value = productTypeCode;
			prms[2].Value = Common.LogonUser.LogonUserDivisionCode;
	
			DataSet ds = Common.StoredProcedure.GetData(STOREDPROC.BloodProductSearch.StoredProcName, prms);
			return ds.Tables[0];
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/14/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1102"> 
		///		<ExpectedInput>Valid product code, OriginalProductGuid, product modification code</ExpectedInput>
		///		<ExpectedOutput>DataTable of Target blood products</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1888"> 
		///		<ExpectedInput>Invalid product modification Code</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Retrieves from database a list of target blood products based on the 
		/// product code, product modification code and division code.
		/// </summary>
		/// <param name="bloodProductGuidArray">Comma delim array of 'from' BloodProduct Guids</param>
		/// <param name="productModificationCode">Product modification code</param>
		/// <param name="modificationMethod">ModificationMethod</param>
		/// <returns>List of blood products matching the search criteria</returns>
		public static DataTable GetTargetBloodProducts(string bloodProductGuidArray, char productModificationCode, Common.ModifyUnitMethod modificationMethod)
		{		
			SqlParameter[] prms =
			{
				new SqlParameter(STOREDPROC.GetTargetProducts.FromBloodProductGuidList, System.Data.SqlDbType.VarChar),
				new SqlParameter(STOREDPROC.GetTargetProducts.ModificationMethod, System.Data.SqlDbType.Int),
				new SqlParameter(STOREDPROC.GetTargetProducts.ProductModificationCode, System.Data.SqlDbType.Char),
				new SqlParameter(STOREDPROC.GetTargetProducts.DivisionCode, System.Data.SqlDbType.VarChar),
			};
	
			//First parameter will be the array
			prms[0].Value = bloodProductGuidArray;
			prms[1].Value = (modificationMethod == Common.ModifyUnitMethod.Open) ? 1 : 0;
			if (modificationMethod == Common.ModifyUnitMethod.None)	prms[1].Value = -1;		//For grabbing expiration date rule
			prms[2].Value = productModificationCode;
			prms[3].Value = Common.LogonUser.LogonUserDivisionCode;
			
			System.Data.DataSet ds = Common.StoredProcedure.GetData(STOREDPROC.GetTargetProducts.StoredProcName, prms);
			
			return ds.Tables[0];
		}


		#endregion

	}
}


